-- update recipient for user add msg event
SET SQL_SAFE_UPDATES = 0;
SET @userId=(SELECT id FROM dtprovider WHERE `dataProviderName`='RCPNT_TYPE_USER_DTP');
UPDATE `sql_dtprovider` SET `sqlQuery`='SELECT \n    T2.id AS ID,\n    T4.`salutationName` AS SALUTATION_NAME,\n    T2.`firstName` AS FIRST_NAME,\n    T2.`middleName` AS MIDDLE_NAME,\n    T2.`lastName` AS LAST_NAME,\n    T3.`emailId` AS EMAIL_ID,\n    T3.`mobileNumber` AS MOBILE_NO,\n    T3.`mobileCountryCode` AS MOBILE_CODE,\n    T3.`alternateEmailId` AS ALTERNATE_EMAIL_ID \nFROM\n    `staffs` T1\n        INNER JOIN\n    `users` T2 ON T2.`id` = T1.`userId`\n        INNER JOIN\n    `persons` T3 ON T3.`id` = T1.`personId`\n        LEFT JOIN\n    `salutations` T4 ON T4.`id` = T3.`salutationId`\nWHERE\n    T2.id IN (namedParams)' WHERE `dataProviderId`=@userId;

-- update recipient for External User Forget Password add msg event
SET @externalId=(SELECT id FROM dtprovider WHERE `dataProviderName`='EXTERNAL_USER_FORGOT_PASSWORD_RECEPIENT_INFO');
UPDATE `sql_dtprovider` SET `sqlQuery`='SELECT \n    T1.id AS ID,\n    T3.`salutationName` AS SALUTATION_NAME,\n    T2.`firstName` AS FIRST_NAME,\n    T2.`middleName` AS MIDDLE_NAME,\n    T2.`lastName` AS LAST_NAME,\n    T2.`emailId` AS EMAIL_ID,\n    T2.`mobileNumber` AS MOBILE_NO,\n    T2.`mobileCountryCode` AS MOBILE_CODE,\n    T2.`alternateEmailId` AS ALTERNATE_EMAIL_ID\nFROM\n    `application` T1\n        INNER JOIN\n    `applicant_person` T2 ON T2.id = T1.applicantPersonId\n        LEFT JOIN\n    `salutations` T3 ON T3.`id` = T2.`salutationId`\nWHERE\n    T1.id IN (namedParams)' WHERE `dataProviderId`=@externalId;

-- update recipient for Student Forget password
SET @studentId=(SELECT id FROM dtprovider WHERE `dataProviderName`='RCPNT_TYPE_STUDENT_FP_DTP');
UPDATE `sql_dtprovider` SET `sqlQuery`='SELECT \n    T2.id AS ID,\n    T4.`salutationName` AS SALUTATION_NAME,\n    T2.`firstName` AS FIRST_NAME,\n    T2.`middleName` AS MIDDLE_NAME,\n    T2.`lastName` AS LAST_NAME,\n    T3.`emailId` AS EMAIL_ID,\n    T3.`mobileNumber` AS MOBILE_NO,\n    T3.`mobileCountryCode` AS MOBILE_CODE,\n	 T3.`alternateEmailId` AS ALTERNATE_EMAIL_ID\nFROM\n    `students` T1\n        INNER JOIN\n    `users` T2 ON T2.`id` = T1.`userId`\n        INNER JOIN\n    `persons` T3 ON T3.`id` = T1.`personId`\n        LEFT JOIN\n    `salutations` T4 ON T4.`id` = T3.`salutationId`\nWHERE\n    T2.id IN (namedParams)' WHERE `dataProviderId`=@studentId;

-- update recipient for parent Forget password
SET @parentId=(SELECT id FROM dtprovider WHERE `dataProviderName`='RCPNT_TYPE_PARENT_DTP');
UPDATE `sql_dtprovider` SET `sqlQuery`='SELECT \n    T2.id AS ID,\n    T4.`salutationName` AS SALUTATION_NAME,\n    T2.`firstName` AS FIRST_NAME,\n    T2.`middleName` AS MIDDLE_NAME,\n    T2.`lastName` AS LAST_NAME,\n    T3.`emailId` AS EMAIL_ID,\n    T3.`mobileNumber` AS MOBILE_NO,\n    T3.`alternateEmailId` AS ALTERNATE_EMAIL_ID,\n    T3.mobileCountryCode AS MOBILE_CODE\nFROM\n    `parents` T1\n        INNER JOIN\n    `users` T2 ON T2.`id` = T1.`userId`\n        INNER JOIN\n    `persons` T3 ON T3.`id` = T1.`personId`\n        LEFT JOIN\n    `salutations` T4 ON T4.`id` = T3.`salutationId`\nWHERE\n    T2.id IN (namedParams)' WHERE `dataProviderId`=@parentId;

-- update recipient for parent Reset password
SET @parentId=(SELECT id FROM dtprovider WHERE `dataProviderName`='PARENT_RESET_PASSWORD_RECIPIENT');
UPDATE `sql_dtprovider` SET `sqlQuery`='SELECT \n    T1.id AS ID,\n    T3.`salutationName` AS SALUTATION_NAME,\n    T1.`firstName` AS FIRST_NAME,\n    T1.`middleName` AS MIDDLE_NAME,\n    T1.`lastName` AS LAST_NAME,\n    T2.`emailId` AS EMAIL_ID,\n    T2.`mobileNumber` AS MOBILE_NO,\n    T2.`mobileCountryCode` AS MOBILE_CODE,\n	 T2.`alternateEmailId` AS ALTERNATE_EMAIL_ID\nFROM\n    `users` T1 \n    LEFT JOIN\n	`parents` T4 on T4.`userId`=T1.`id`\n	LEFT JOIN\n    `persons` T2 ON T2.`id` = T4.`personId`	\n	LEFT JOIN\n    `salutations` T3 ON T3.`id` = T2.`salutationId`\nWHERE\n    T4.userId IN (namedParams)' WHERE `dataProviderId`=@parentId;

-- update recipient for student / staff Reset password
SET @resetId=(SELECT id FROM dtprovider WHERE `dataProviderName`='RESET_PASSWORD_RECIPIENT');
UPDATE `sql_dtprovider` SET `sqlQuery`='SELECT \n    T1.id AS ID,\n    T3.`salutationName` AS SALUTATION_NAME,\n    T1.`firstName` AS FIRST_NAME,\n    T1.`middleName` AS MIDDLE_NAME,\n    T1.`lastName` AS LAST_NAME,\n    T2.`emailId` AS EMAIL_ID,\n    T2.`mobileNumber` AS MOBILE_NO,\n    T2.`mobileCountryCode` AS MOBILE_CODE,\n		T2.`alternateEmailId` AS ALTERNATE_EMAIL_ID\nFROM\n    `users` T1 \n    LEFT JOIN\n	`students` T4 on T4.`userId`=T1.`id`\n	LEFT JOIN\n	`staffs` T5 on T5.`userId`=T1.`id`\n	LEFT JOIN\n    `persons` T2 ON T2.`id` = T4.`personId` or T2.`id` = T5.`personId`	\n	LEFT JOIN\n    `salutations` T3 ON T3.`id` = T2.`salutationId`\nWHERE\n    T4.userId IN (namedParams) or T5.userId IN(namedParams)' WHERE `dataProviderId`=@resetId;

-- update recipient for Applicant Reset password
SET @appResetId=(SELECT id FROM dtprovider WHERE `dataProviderName`='APPLICANT_RESET_PASSWORD_RECIPIENT');
UPDATE `sql_dtprovider` SET `sqlQuery`='SELECT \n    T1.id AS ID,\n    T5.`salutationName` AS SALUTATION_NAME,\n    T4.`firstName` AS FIRST_NAME,\n    T4.`middleName` AS MIDDLE_NAME,\n    T4.`lastName` AS LAST_NAME,\n    T4.`emailId` AS EMAIL_ID,\n    T4.`mobileNumber` AS MOBILE_NO,\n    T4.`mobileCountryCode` AS MOBILE_CODE,\n    T4.`alternateEmailId` AS ALTERNATE_EMAIL_ID\nFROM\n    `external_users` T1 \n        INNER JOIN\n	`external_user_association` T2 ON T2.`externalUserId` =T1.`id`\n		LEFT JOIN\n    `application` T3 ON T3.`id` = T2.`applicationId`\n		LEFT JOIN\n    `applicant_person` T4 ON T4.`id` = T3.`applicantPersonId`\n        LEFT JOIN\n    `salutations` T5 ON T5.`id` = T4.`salutationId`\nWHERE\n    T1.id IN(namedParams)' WHERE `dataProviderId`=@appResetId;


SET SQL_SAFE_UPDATES = 1;